/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsComplianceConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsSearchOperationListener;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsValve;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.FlsFieldFilter;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.FlsQueryCacheWeightProvider;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.lucene.SearchGuardFlsDlsIndexSearcherWrapper;
import com.floragunn.searchguard.license.LicenseChangeListener;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.SearchOperationListener;

public class LegacyDlsFlsModule
implements SearchGuardModule,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(LegacyDlsFlsModule.class);
    private DlsFlsValve dlsFlsValve;
    private DlsFlsSearchOperationListener dlsFlsSearchOperationListener;
    private FlsFieldFilter flsFieldFilter;
    private FlsQueryCacheWeightProvider flsQueryCacheWeightProvider;
    private final ComponentState componentState = new ComponentState(1002, null, "dlsfls_legacy", LegacyDlsFlsModule.class).requiresEnterpriseLicense();
    private AtomicReference<DlsFlsProcessedConfig> config = new AtomicReference<DlsFlsProcessedConfig>(DlsFlsProcessedConfig.DEFAULT);
    private DlsFlsComplianceConfig complianceConfig;
    private Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>> directoryReaderWrapper;

    public Collection<Object> createComponents(final BaseDependencies baseDependencies) {
        this.complianceConfig = new DlsFlsComplianceConfig(baseDependencies.getSettings(), baseDependencies.getConfigurationRepository(), baseDependencies.getLocalClient());
        baseDependencies.getLicenseRepository().subscribeOnLicenseChange((LicenseChangeListener)this.complianceConfig);
        this.dlsFlsValve = new DlsFlsValve(baseDependencies.getSettings(), baseDependencies.getLocalClient(), baseDependencies.getClusterService(), baseDependencies.getIndexNameExpressionResolver(), baseDependencies.getGuiceDependencies(), baseDependencies.getxContentRegistry(), baseDependencies.getThreadPool().getThreadContext(), baseDependencies.getConfigurationRepository(), this.config, this.complianceConfig);
        this.dlsFlsSearchOperationListener = new DlsFlsSearchOperationListener(baseDependencies.getThreadPool(), this.dlsFlsValve.getDlsQueryParser(), this.config);
        this.flsFieldFilter = new FlsFieldFilter(baseDependencies.getThreadPool(), this.config);
        this.flsQueryCacheWeightProvider = new FlsQueryCacheWeightProvider(baseDependencies.getThreadPool(), this.config);
        this.directoryReaderWrapper = indexService -> new SearchGuardFlsDlsIndexSearcherWrapper((IndexService)indexService, baseDependencies.getSettings(), baseDependencies.getClusterService(), baseDependencies.getAuditLog(), this.complianceConfig, this.config);
        ConfigurationRepository configurationRepository = baseDependencies.getConfigurationRepository();
        final ClusterService clusterService = baseDependencies.getClusterService();
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            public void onChange(ConfigMap configMap) {
                DlsFlsProcessedConfig newConfig = DlsFlsProcessedConfig.createFrom(configMap, LegacyDlsFlsModule.this.componentState, baseDependencies.getIndexNameExpressionResolver(), clusterService);
                DlsFlsProcessedConfig oldConfig = (DlsFlsProcessedConfig)LegacyDlsFlsModule.this.config.get();
                if (oldConfig.isEnabled() != newConfig.isEnabled()) {
                    log.info(newConfig.isEnabled() ? "Legacy DLS/FLS implementation is now ENABLED" : "Legacy DLS/FLS implementation is now DISABLED");
                }
                LegacyDlsFlsModule.this.config.set(newConfig);
            }
        });
        return ImmutableList.empty();
    }

    public ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> getDirectoryReaderWrappersForNormalOperations() {
        return ImmutableList.of(this.directoryReaderWrapper);
    }

    public ImmutableList<SearchOperationListener> getSearchOperationListeners() {
        return ImmutableList.of((Object)this.dlsFlsSearchOperationListener);
    }

    public ImmutableList<SyncAuthorizationFilter> getSyncAuthorizationFilters() {
        return ImmutableList.of((Object)this.dlsFlsValve);
    }

    public ImmutableList<Function<String, Predicate<String>>> getFieldFilters() {
        return ImmutableList.of((Object)this.flsFieldFilter);
    }

    public ImmutableList<SearchGuardModule.QueryCacheWeightProvider> getQueryCacheWeightProviders() {
        return ImmutableList.of((Object)this.flsQueryCacheWeightProvider);
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public ImmutableSet<String> getCapabilities() {
        return ImmutableSet.of((Object)"dls", (Object[])new String[]{"fls", "field_masking"});
    }
}

